<?php
/*
Author: VarkTech
Author URI: http://varktech.com
*
Copyright 2012 AardvarkPC Services NZ, all rights reserved.  See license.txt for more details.
*
*/
   
class VTMAM_Rule_update {
	

	public function __construct(){  
        $this->vtmam_update_rule();
    }
            
  public  function vtmam_update_rule () {
      global $post, $vtmam_rule; 
      $post_id = $post->ID;                                                                                                                                                          
      $vtmam_rule_new = new VTMAM_Rule();   //  always  start with fresh copy
      $selected = 's';

      $vtmam_rule = $vtmam_rule_new;  //otherwise vtmam_rule is not addressable!
       
     //*****************************************
     //  FILL / upd VTMAM_RULE...
     //*****************************************
     //   Candidate Population
     
     $vtmam_rule->post_id = $post_id;

     if ( ($_REQUEST['post_title'] > ' ' ) ) {
       //do nothing
     }
     else { 
       $vtmam_rule->rule_error_message[] = __('The Rule needs to have a title, but title is empty.', 'vtmam');
     }
      
     $vtmam_rule->inpop_selection = $_REQUEST['popChoice'];
     switch( $vtmam_rule->inpop_selection ) {
        case 'cart':
              $vtmam_rule->inpop[0]['user_input'] = $selected;
              $this->vtmam_set_default_or_values();
          break;
        case 'groups':
              $vtmam_rule->inpop[1]['user_input'] = $selected;
              //  $vtmam_checkbox_classes = new VTMAM_Checkbox_classes;
                  //get all checked taxonomies/roles as arrays
             if(!empty($_REQUEST['tax-input-prodcat-in'])) {
                $vtmam_rule->prodcat_in_checked = $_REQUEST['tax-input-prodcat-in'];      
             }
             if(!empty($_REQUEST['tax-input-rulecat-in'])) { 
                $vtmam_rule->rulecat_in_checked = $_REQUEST['tax-input-rulecat-in'];
             }
             if(!empty($_REQUEST['tax-input-role-in'])) {
                $vtmam_rule->role_in_checked = $_REQUEST['tax-input-role-in'];
             }
             if ((!$vtmam_rule->prodcat_in_checked) && (!$vtmam_rule->rulecat_in_checked) && (!$vtmam_rule->role_in_checked))  {
                $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "Use Selection Groups" was chosen, but no Categories or Roles checked', 'vtmam');
             }                                  
             //   And/Or switch for category/role relationship  
             $vtmam_rule->role_and_or_in_selection  = $_REQUEST['andorChoice'];             
             switch( $vtmam_rule->role_and_or_in_selection ) {
                case 'and':
                    $vtmam_rule->role_and_or_in[0]['user_input'] = $selected;
                    if ((!$vtmam_rule->prodcat_in_checked) && (!$vtmam_rule->rulecat_in_checked) && (!$vtmam_rule->role_in_checked))  {
                        $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "Use Selection Groups" and "And" was chosen, but no Categories or Roles are checked', 'vtmam');
                    } else 
                    if ((!$vtmam_rule->prodcat_in_checked) && (!$vtmam_rule->rulecat_in_checked)) {
                        $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "Use Selection Groups" and "And" was chosen, but no Categories are checked. <br><br><br><br><em>If Roles alone are desired, please select "OR".</em>', 'vtmam');
                    } else
                    if (!$vtmam_rule->role_in_checked)  {
                        $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "Use Selection Groups" and "And" was chosen, but no Roles are checked.  <br><br><br><br><em>If Categories alone are desired, please select "OR".</em>', 'vtmam');
                    }
                  break;
                case 'or':
                    $vtmam_rule->role_and_or_in[1]['user_input'] = $selected;
                  break;
                default:  
                    $this->vtmam_set_default_or_values();
                  break;  
              }
          break;
        case 'vargroup':
            $vtmam_rule->inpop[2]['user_input'] = $selected; 
            $vtmam_rule->inpop_varProdID['value'] = $_REQUEST['inVarProdID'];
            
            if ($vtmam_rule->inpop_varProdID['value'] == ' '){
              $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "*Single Product with variations* was chosen, but not Product ID was supplied.', 'vtmam');
            }  
            if ( is_numeric($vtmam_rule->inpop_varProdID['value']) === false ) {
               $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "*Single Product with variations* was chosen, but Product ID was not numeric.', 'vtmam');              
            } else { 
                $test_post = get_post($vtmam_rule->inpop_varProdID['value']);
                
                if ( !$test_post ) {
                   $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "*Single Product with variations* was chosen, but Product ID was not found.', 'vtmam');              
                }  else {
                   $vtmam_rule->inpop_varProdID_name = $test_post->post_title . ' (Variations)';
                   $product_has_variations = vtmam_test_for_variations($vtmam_rule->inpop_varProdID['value']);
                   if ($product_has_variations == 'yes') {
                     if(!empty($_REQUEST['tax-input-var-in'])) { 
                        $vtmam_rule->var_in_checked = $_REQUEST['tax-input-var-in'];
                     }
                     if (!$vtmam_rule->var_in_checked) {
                       $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "Single Product with variations" was chosen, but no Variations checked', 'vtmam');
                     }
                  } else {
                     $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "Single Product with variations" was chosen, but no Product has no Variations.  Please use "Single Product Only" option.', 'vtmam');
                  }
                }
            }
            
            $this->vtmam_set_default_or_values();
                    
          break;
        case 'single':
            $vtmam_rule->inpop[3]['user_input'] = $selected;                                        
            // edit for single product ID
            $vtmam_rule->inpop_singleProdID['value'] = $_REQUEST['singleProdID'];
            if ($vtmam_rule->inpop_singleProdID['value'] == ' '){
              $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "*Single Product Only* was chosen, but not Product ID was supplied.', 'vtmam');
            }  
            if ( is_numeric($vtmam_rule->inpop_singleProdID['value']) === false ) {
               $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "*Single Product Only* was chosen, but Product ID was not numeric.', 'vtmam');              
            } else { 
                $test_post = get_post($vtmam_rule->inpop_singleProdID['value']);
                if ( !$test_post ) {
                   $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "*Single Product Only* was chosen, but Product ID was not found.', 'vtmam');              
                }  else {
                   $vtmam_rule->inpop_singleProdID_name = $test_post->post_title;
                   $product_has_variations = vtmam_test_for_variations($vtmam_rule->inpop_singleProdID['value']);
                   if ($product_has_variations == 'yes') {
                        $vtmam_rule->rule_error_message[] = __('In Cart Search Criteria Selection Metabox, "Single Product Only" was chosen, but ** Product has Variations **.  Please use "Single Product with variations" option.', 'vtmam');
                   } 
                }
            }
            $this->vtmam_set_default_or_values();
          break;
      }

  
      
          
     //   Population Handling Specifics   
     $vtmam_rule->specChoice_in_selection = $_REQUEST['specChoice'];
     
     switch( $vtmam_rule->specChoice_in_selection ) {
        case 'all':
            $vtmam_rule->specChoice_in[0]['user_input'] = $selected;
          break;
        case 'each':
            $vtmam_rule->specChoice_in[1]['user_input'] = $selected;
          break;
        case 'any':
            $vtmam_rule->specChoice_in[2]['user_input'] = $selected;
            if (empty($_REQUEST['anyChoice-max'])) {
                $vtmam_rule->rule_error_message[] = __('In Select Rule Application Metabox, "*Any* in the Population" was chosen, but Min and Max products count not filled in', 'vtmam');
            } else { 
                $vtmam_rule->anyChoice_max['value'] = $_REQUEST['anyChoice-max'];
                if ($vtmam_rule->anyChoice_max['value'] == ' '){
                  $vtmam_rule->rule_error_message[] = __('In Select Rule Application  Metabox, "*Any* in the Population" was chosen, but Min and Max products count not filled in', 'vtmam');
                } 
                if ( is_numeric($vtmam_rule->anyChoice_max['value'])  === false  ) {
                   $vtmam_rule->rule_error_message[] = __('In Select Rule Application  Metabox, "*Any* in the Population" was chosen, but Min and Max products count not numeric', 'vtmam');              
                }
          }    
          break;
      }
              
       
     //   Min and Max Amount for this role
     $vtmam_rule->amtSelected_selection = $_REQUEST['amtSelected']; 
     
     switch( $vtmam_rule->amtSelected_selection ) {
        case 'quantity':
            $vtmam_rule->amtSelected[0]['user_input'] = $selected;
          break;
        case 'currency':
            $vtmam_rule->amtSelected[1]['user_input'] = $selected;
          break;
     } 
     if (empty($_REQUEST['amtChoice-count'])) {
        $vtmam_rule->rule_error_message[] = __('In Min and Max Amount for this role Metabox, Min and Max Amount not filled in', 'vtmam');
     } else { 
        $vtmam_rule->minandmax_amt['value'] = $_REQUEST['amtChoice-count'];
        if ($vtmam_rule->minandmax_amt['value'] == ' '){
          $vtmam_rule->rule_error_message[] = __('In Min and Max Amount for this role Metabox, Min and Max Amount not filled in', 'vtmam');
        }  
        if ( is_numeric($vtmam_rule->minandmax_amt['value']) === false  ) {
           $vtmam_rule->rule_error_message[] = __('In Min and Max Amount for this role Metabox, Min and Max Amount not numeric', 'vtmam');              
        }
     }
    
                     
     //   Min and Max Direction choice                                                           
     $vtmam_rule->minandmaxSelected_selection = $_REQUEST['minandmaxSelected']; 
     
     switch( $vtmam_rule->minandmaxSelected_selection ) {
        case 'Minimum':
            $vtmam_rule->minandmaxSelected[0]['user_input'] = $selected;
          break;
        case 'Maximum':
            $vtmam_rule->minandmaxSelected[1]['user_input'] = $selected;
          break;
     } 
    
     //   Rule Type choice                                                           
     $vtmam_rule->rule_typeSelected_selection = $_REQUEST['rule-typeSelected']; 
     
     switch( $vtmam_rule->rule_typeSelected_selection ) {
        case 'cart':
            $vtmam_rule->rule_typeSelected[0]['user_input'] = $selected;
          break;
        case 'lifetime':
            $vtmam_rule->rule_typeSelected[1]['user_input'] = $selected;
          break;
     }
/*
    if ( ( $vtmam_rule->minandmaxSelected[0]['user_input']    == $selected ) &&
         ( $vtmam_rule->rule_typeSelected[1]['user_input'] == $selected ) ) {
       $vtmam_rule->rule_error_message[] = __('Lifetime rule type may not be chosen for Minimum Rule, please select Cart.', 'vtmam');   
    }
*/
     //   Min Rule Type choice                                                           
     $vtmam_rule->minRule_typeSelected_selection = $_REQUEST['minRule-typeSelected']; 
     
     switch( $vtmam_rule->minRule_typeSelected_selection ) {
        case 'cart':
            $vtmam_rule->minRule_typeSelected[0]['user_input'] = $selected;
          break;
        case 'lifetime':
            $vtmam_rule->minRule_typeSelected[1]['user_input'] = $selected;
          break;
     }

     //v1.07.9 begin
     $vtmam_rule->repeatingGroups = $_REQUEST['repeating-groups'];
     if ( ( $vtmam_rule->repeatingGroups == '')  ||
          ( $vtmam_rule->repeatingGroups == ' ') ) {
        $vtmam_rule->repeatingGroups = '';   //re-initialize if default msg still there...
     } else {
       if ( is_numeric($vtmam_rule->repeatingGroups)  === false  ) {
           $vtmam_rule->rule_error_message[] = __('If Repeating Groups is chosen, this must be a number greater than 0.', 'vtmam');              
       }
     }  
     //v1.07.9 end
    
     //v1.07 begin
     $vtmam_rule->custMsg_text = $_REQUEST['cust-msg-text'];
     global $vtmam_info;
     if ( $vtmam_rule->custMsg_text == $vtmam_info['default_full_msg']) {
        $vtmam_rule->custMsg_text = '';   //re-initialize if default msg still there...
     }   
     //v1.07 end
              
    
    //*****************************************
    //  If errors were found, the error message array will be displayed by the UI on next screen send.
    //*****************************************
    if  ( sizeof($vtmam_rule->rule_error_message) > 0 ) {
      $vtmam_rule->rule_status = 'pending';
    } else {
      $vtmam_rule->rule_status = 'publish';
    }
   
    $rules_set_found = false;
    $vtmam_rules_set = get_option( 'vtmam_rules_set' ); 
    if ($vtmam_rules_set) {
      $rules_set_found = true;
    }
          
    if ($rules_set_found) {
      $rule_found = false;
      for($i=0; $i < sizeof($vtmam_rules_set); $i++) { 
         if ($vtmam_rules_set[$i]->post_id == $post_id) {
            $vtmam_rules_set[$i] = $vtmam_rule;
            $i =  sizeof($vtmam_rules_set);
            $rule_found = true; 
         }
      }
      if (!$rule_found) {
         $vtmam_rules_set[] = $vtmam_rule;
      } 
    } else {
      $vtmam_rules_set = array ();
      $vtmam_rules_set[] = $vtmam_rule;
    }
  
    if ($rules_set_found) {
      update_option( 'vtmam_rules_set',$vtmam_rules_set );
    } else {
      add_option( 'vtmam_rules_set',$vtmam_rules_set );
    }
     
  } //end function

 //default to 'OR', as the default value goes away and may be needed if the user switches back to 'groups'...
  public function vtmam_set_default_or_values () {
    global $vtmam_rule;  
    $vtmam_rule->role_and_or_in[1]['user_input'] = 's'; //'s' = 'selected'
    $vtmam_rule->role_and_or_in_selection = 'or'; 
  } 

  
} //end class
