<?php
/*
Plugin Name: VarkTech Min and Max Purchase Pro for WooCommerce
Plugin URI: http://varktech.com
Description: Pro e-commerce add-on for WooCommerce, supplying min and max purchase functionality.
Version: 1.07.8
Author: VarkTech
Author URI: http://varktech.com
*
Copyright 2013 AardvarkPC Services NZ, all rights reserved.  See license.txt for more details.
*
*/



//nutso problems with activation hook and class, so sat it outside....
 if (is_admin()){                                  
   register_activation_hook(__FILE__,  'vtmam_pro_activation');
   register_uninstall_hook (__FILE__,  'vtmam_pro_uninstall_hook');   
}

     
class VTMAM_Pro_Controller{
	
	public function __construct(){    
    
    
    add_action('init', array( &$this, 'vtmam_pro_controller_init' ));
        
		define('VTMAM_PRO_PLUGIN_NAME',                       'Maximum Purchase Pro for WooCommerce');
    define('VTMAM_PRO_FREE_PLUGIN_NAME',                  'Maximum Purchase for WooCommerce');
    define('VTMAM_PRO_VERSION',                           '1.07.8');
    define('VTMAM_PRO_MINIMUM_REQUIRED_FREE_VERSION',     '1.07.9');  //required version of vt-maximum-purchase...
    define('VTMAM_PRO_LAST_UPDATE_DATE',                  '2015-06-10');
    
    define('VTMAM_PRO_DIRNAME',                           ( dirname( __FILE__ ) ));
    define('VTMAM_PRO_BASE_NAME',                          basename(VTMAM_PRO_DIRNAME));
    define('VTMAM_PRO_REMOTE_VERSION_FILE',               'http://www.varktech.com/pro/vtmam-pro-for-woocommerce-version.txt');
    define('VTMAM_PRO_DOWNLOAD_FREE_VERSION_BY_PARENT',   'http://wordpress.org/extend/plugins/maximum-purchase-for-woocommerce/');
    define('VTMAM_PRO_PLUGIN_SLUG',                        plugin_basename(__FILE__));
    
    //NEW table names
    global $wpdb;
    define('MAX_PURCHASE_RULE_PURCHASER',                 $wpdb->prefix.'vtmam_rule_purchaser');      
    define('MAX_PURCHASE_RULE_PRODUCT',                   $wpdb->prefix.'vtmam_rule_product');         
	}   //end constructor

	                                                             
 /* ************************************************
 **   Overhead and Init
 *************************************************** */
	public function vtmam_pro_controller_init(){
     if (is_admin()){
        // echo 'after plugin row executed'; //mwnt
        add_action('after_plugin_row', array( &$this, 'vtmam_pro_check_plugin_version' ));
        add_action('admin_init', array( &$this, 'vtmam_pro_check_for_free_version' ));
     }
  }
    

  function vtmam_pro_check_for_free_version() {
  
    global $wp_version;
    $plugin = VTMAM_PRO_PLUGIN_SLUG;
    $free_plugin_download = '<a  href="' . VTMAM_PRO_DOWNLOAD_FREE_VERSION_BY_PARENT . '"  title="Download from wordpress.org"> WordPress.org </a>';
    $plugin_name = VTMAM_PRO_PLUGIN_NAME;
    $free_plugin_name = VTMAM_PRO_FREE_PLUGIN_NAME;
    
    if(!defined('VTMAM_VERSION')) { 
  			if( is_plugin_active($plugin) ) {
  			   deactivate_plugins( $plugin );
        }
        //add_action('admin_head', array( &$this, 'vtmam_pro_addAlert_message1' ));
        $message =  __('<strong>Please Download and/or Activate ' .$free_plugin_name.' (the Free version). </strong><br>It must be installed and active, before the Pro version can be activated.  The Free version can be downloaded from '  . $free_plugin_download , 'vtmampro');
        $admin_notices = '<div id="message" class="error fade" style="background-color: #FFEBE8 !important;"><p>' . $message . ' </p></div>';
        add_action( 'admin_notices', create_function( '', "echo '$admin_notices';" ) );

        return;
    }
  
    $new_version =      VTMAM_PRO_MINIMUM_REQUIRED_FREE_VERSION;
    $current_version =  VTMAM_VERSION;
    if( (version_compare(strval($new_version), strval($current_version), '>') == 1) ) {   //'==1' = 2nd value is lower  
        if( is_plugin_active($plugin) ) {
  			   deactivate_plugins( $plugin );
        }
        $message =  __('<strong>Please Update ' .$free_plugin_name.' (the Free version). </strong><br>It must be current, before the Pro version can be activated.  The Free version can be downloaded from '  . $free_plugin_download , 'vtmampro');
        $admin_notices = '<div id="message" class="error fade" style="background-color: #FFEBE8 !important;"><p>' . $message . ' </p></div>';
        add_action( 'admin_notices', create_function( '', "echo '$admin_notices';" ) );
        return;
    }    
  }
 
  /* ************************************************
  **   Admin - Uninstall Hook and cleanup
  *************************************************** */ 
  function vtmam_pro_uninstall_hook() {
      if ( !defined( 'WP_UNINSTALL_PLUGIN' ) ) {
      	exit ();
      }

  }


function vtmam_pro_check_plugin_version( $plugin ) {
  /*
    $plugin is system supplied if 
    add_action('after_plugin_row', array( &$this, 'vtmam_pro_check_plugin_version' ));
    is used.  
    
    $plugin = 'vt-maximum-purchase-pro/vt-maximum-purchase-pro.php';
  */  
  if( strpos( VTMAM_PRO_BASE_NAME.'/'.__FILE__,$plugin ) !== false ) { 
  
   // $new_version = wp_remote_fopen(VTMAM_PRO_REMOTE_VERSION_FILE, 'r');
    $new_version = wp_remote_fopen(VTMAM_PRO_REMOTE_VERSION_FILE);
    
   // echo '<br>External file version= ' .$new_version;  //mwn
 
    if( $new_version ) {      
      $current_version = VTMAM_PRO_VERSION;
      $installation_location = VTMAM_PRO_INSTALLATION_INSTRUCTIONS_BY_PARENT;
      if( (version_compare(strval($new_version), strval($current_version), '>') == 1) ) {   //'==1' = 2nd value is lower 
        
      //  echo '<br>new version found, current version= ' .$current_version; //mwn
        
        $update_msg = __('There is a new version of ', 'vtmam') . VTMAM_PRO_PLUGIN_NAME . __(' available.', 'vtmam') ;
        echo ' <td colspan="5" class="plugin-update" style="line-height:1.2em; font-size:11px; padding:1px;">
                <div style="color:#000; font-weight:bold; margin:4px; padding:6px 5px; background-color:#fffbe4; border-color:#dfdfdf; border-width:1px; border-style:solid; -moz-border-radius:5px; -khtml-border-radius:5px; -webkit-border-radius:5px; border-radius:5px;">'.  strip_tags( $update_msg ) .' <a href="'.$installation_location.'" target="_blank">View version ' . $new_version . ' for details</a>.</div	>
              </td>';
      } else {
        return;
      }
    }
 
  }
}

  
} //end class


//****************************************
//V1.07.5 BEGIN
//FOR SOME HOSTS, WARNINGS ARE GENERATED **BEFORE** ACTIVATION...   
/*
** define Globals 
*/
 $vtmam_setup_options;  //from FREE version
vtmam_pro_debug_options();

  function vtmam_pro_debug_options(){   
    global $vtmam_setup_options;
    if ( ( isset( $vtmam_setup_options['debugging_mode_on'] )) &&
         ( $vtmam_setup_options['debugging_mode_on'] == 'yes' ) ) {  
      error_reporting(E_ALL);  
    }  else {
      error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR);    //only allow FATAL error types
    }
  }
//V1.07.5 END  
//****************************************     




$vtmam_pro_controller = new VTMAM_Pro_Controller;


  /* ************************************************
  **   Admin - Install Hook  [outside the primary class due to WP bug]
  *************************************************** */ 
  function vtmam_pro_activation( $plugin ) {   

    //CREATE Tables for Lifetime Maximum tracking
    global $wpdb;
  	$wpdb->hide_errors();    
  	$collate = '';
    if ( $wpdb->has_cap('collation') ) {   //v1.07
  		if( ! empty($wpdb->charset ) ) $collate .= "DEFAULT CHARACTER SET $wpdb->charset";
  		if( ! empty($wpdb->collate ) ) $collate .= " COLLATE $wpdb->collate";
    }
    
    $purchaser_table = $wpdb->prefix.'vtmam_rule_purchaser';
    $product_table = $wpdb->prefix.'vtmam_rule_product';

    //if the table doesn't already exist v1.07
    if($wpdb->get_var("SHOW TABLES LIKE '$purchaser_table'") != $purchaser_table) { // v1.07    
        $sql = "
            CREATE TABLE  `$purchaser_table` (
                  id bigint NOT NULL AUTO_INCREMENT,
                  rule_id bigint,
                  purchaser_ip_address VARCHAR(50),                 
                  purchaser_email VARCHAR(100),
                  billto_name VARCHAR(50),
                  billto_address VARCHAR(100),
                  billto_city VARCHAR(100),
                  billto_state VARCHAR(100),
                  billto_postcode VARCHAR(100),
                  billto_country VARCHAR(100),
                  shipto_name VARCHAR(50),
                  shipto_address VARCHAR(100),
                  shipto_city VARCHAR(100),
                  shipto_state VARCHAR(100),
                  shipto_postcode VARCHAR(100),
                  shipto_country VARCHAR(100),      
                  rule_currency_total DECIMAL(11,2),
                  rule_units_total DECIMAL(11,2),             
                  orig_rule_inpop_selection VARCHAR(10),            
                  orig_rule_inpop_varprodid bigint,
                  orig_rule_var_in_checked VARCHAR(100),
                  orig_rule_inpop_singleprodid bigint,
                  orig_rule_prodcat_in_checked VARCHAR(100),    
                  orig_rule_rulecat_in_checked VARCHAR(100),  
                  orig_rule_role_in_checked VARCHAR(100),
                  orig_rule_role_and_or_in_selection VARCHAR(10),  
                  orig_rule_specchoice_in_selection VARCHAR(10),
                  orig_rule_anychoice_max DECIMAL(11,2),
                  orig_rule_amtselected_selection VARCHAR(10),
                  orig_rule_maximum_amt DECIMAL(11,2),
              KEY id (id, rule_id)
            ) $collate ;      
            ";
         vtmam_create_table( $sql );
    }
    
    //if the table doesn't already exist v1.07
    if($wpdb->get_var("SHOW TABLES LIKE '$product_table'") != $product_table) { // v1.07       
        $sql = "             
            CREATE TABLE  `$product_table`   (
                id bigint NOT NULL AUTO_INCREMENT,
                rule_purchaser_row_id bigint,
                rule_id bigint,                
                product_id bigint,
                product_title VARCHAR(100), 
                product_price_total DECIMAL(11,2),
                product_qty_total DECIMAL(11,2),
            KEY id (id, rule_purchaser_row_id, rule_id)
            ) $collate;
          ";     
         vtmam_create_table( $sql );
    }
  }
  
   function vtmam_create_table( $sql ) {
      require_once(ABSPATH . 'wp-admin/includes/upgrade.php');	        
      dbDelta($sql);
      return;  
   }
       
  /* ************************************************
  **   Admin - Uninstall Hook and cleanup
  *************************************************** */ 
  function vtmam_pro_uninstall_hook() {
    /*  if ( !defined( 'WP_UNINSTALL_PLUGIN' ) ) {
      	exit ();
      }   */
      echo 'uninstall reached successfully!!' ;
  }
