<?php

add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

function my_theme_enqueue_styles() {

    $parent_style = 'parent-style';

    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style )
    );
}

/*
 * Champs standard de checkout_fields
 *
 * 
 * billing
 *     billing_first_name
 *     billing_last_name
 *     billing_company
 *     billing_address_1
 *     billing_address_2
 *     billing_city
 *     billing_postcode
 *     billing_country
 *     billing_state
 *     billing_email
 *     billing_phone
 * shipping
 *     shipping_first_name
 *     shipping_last_name
 *     shipping_company
 *     shipping_address_1
 *     shipping_address_2
 *     shipping_city
 *     shipping_postcode
 *     shipping_country
 *     shipping_state
 * account
 *     account_username
 *     account_password
 *     account_password-2
 * order
 *     order_comments
 */

/*
 * Propriété de chaque champ
 *
 * 
 * type – type of field (text, textarea, password, select)
 * label – label for the input field
 * placeholder – placeholder for the input
 * class – class for the input
 * required – true or false, whether or not the field is require
 * clear – true or false, applies a clear fix to the field/label
 * label_class – class for the label element
 * options – for select boxes, array of options (key => value pairs)
 *
 */

add_filter( 'woocommerce_checkout_fields' , 'STDI_modify_checkout_fields' );

function STDI_modify_checkout_fields( $fields )
{
	/* L'ELEVE */
	
	$fields['billing']['billing_student_first_name'] = array(
		'type'		=> 'text',
		'label'		=> 'Prénom',
		'required'	=> true,
		'class'		=> array( 'form-row-wide' ),
		'clear'		=> true
	);

	$fields['billing']['billing_student_last_name'] = array(
		'type'		=> 'text',
		'label'		=> 'Nom',
		'required'	=> true,
		'class'		=> array( 'form-row-wide' ),
		'clear'		=> true
	);

	$fields['billing']['billing_student_grade'] = array(
		'type'		=> 'select',
		'label'		=> 'Classe',
		'required'	=> true,
		'class'		=> array( 'form-row-wide' ),
		'clear'		=> true,
		'options'	=> array(
			'MS'		=> 'MS',
			'GS'		=> 'GS',
			'CP'		=> 'CP',
			'CE1'		=> 'CE1',
			'CE2'		=> 'CE2',
			'CM1'		=> 'CM1',
			'CM2'		=> 'CM2',
			'6e'		=> '6e',
			'5e'		=> '5e',
			'4e'		=> '4e',
			'3e'		=> '3e',
			'Seconde'	=> 'Seconde',
			'Première'	=> 'Première',
			'Terminale'	=> 'Terminale'
		)
	);
	
	/* LES PARENTS */
	
	$fields['billing']['billing_first_name']['label'] = 'Prénom';
	$fields['billing']['billing_first_name']['required'] = true;
	$fields['billing']['billing_first_name']['class'] = array( 'form-row-wide' );
	$fields['billing']['billing_first_name']['clear'] = true;

	$fields['billing']['billing_last_name']['label'] = 'Nom';
	$fields['billing']['billing_last_name']['required'] = true;
	$fields['billing']['billing_last_name']['class'] = array( 'form-row-wide' );
	$fields['billing']['billing_last_name']['clear'] = true;

	$fields['billing']['billing_address_1']['required'] = true;
	$fields['billing']['billing_address_1']['class'] = array( 'form-row-wide' );
	$fields['billing']['billing_address_1']['clear'] = true;
	
	$fields['billing']['billing_address_2']['required'] = false;
	$fields['billing']['billing_address_2']['class'] = array( 'form-row-wide' );
	$fields['billing']['billing_address_2']['clear'] = true;
	
	$fields['billing']['billing_postcode']['required'] = true;
	$fields['billing']['billing_postcode']['class'] = array( 'form-row-wide' );
	$fields['billing']['billing_postcode']['clear'] = true;
	
	$fields['billing']['billing_city']['required'] = true;
	$fields['billing']['billing_city']['class'] = array( 'form-row-wide' );
	$fields['billing']['billing_city']['clear'] = true;
	
	$fields['billing']['billing_phone']['label'] = 'Téléphone';
	$fields['billing']['billing_phone']['required'] = false;
	$fields['billing']['billing_phone']['class'] = array( 'form-row-wide' );
	$fields['billing']['billing_phone']['clear'] = true;

	/* CHAMPS INUTILES */
	
	unset( $fields['billing']['billing_company'] );
	unset( $fields['billing']['billing_country'] );
	unset( $fields['billing']['billing_state'] );
	unset( $fields['billing']['billing_email'] );

	return $fields;
}

/*
 * There are 9 hooks on the checkout page:
 *
 * woocommerce_before_checkout_form
 * woocommerce_checkout_before_customer_details
 * woocommerce_checkout_billing
 * woocommerce_checkout_shipping
 * woocommerce_checkout_after_customer_details
 * woocommerce_checkout_before_order_review
 * woocommerce_checkout_order_review
 * woocommerce_checkout_after_order_review
 * woocommerce_after_checkout_form
 */

add_action( 'woocommerce_checkout_update_order_meta', 'STDI_add_order_meta', 10, 2 );
 
function STDI_add_order_meta( $order_id, $posted )
{
	if ( isset( $posted['billing_student_first_name'] ) )
	{
		update_post_meta( $order_id, "Prénom de l'élève", sanitize_text_field( $posted['billing_student_first_name'] ) );
	}
	if ( isset( $posted['billing_student_last_name'] ) )
	{
		update_post_meta( $order_id, "Nom de l'élève", sanitize_text_field( $posted['billing_student_last_name'] ) );
	}
    if ( isset( $posted['billing_student_grade'] ) && in_array( $posted['billing_student_grade'], array( 'MS', 'GS', 'CP', 'CE1', 'CE2', 'CM1', 'CM2', '6e', '5e', '4e', '3e', 'Seconde', 'Première', 'Terminale' ) ) )
	{
		update_post_meta( $order_id, 'Classe', $posted['billing_student_grade'] );
	}
}

/*
 * BEFORE MY ACCOUNT
 */

add_action('woocommerce_before_my_account', 'STDI_before_my_account', 10, 0);

function STDI_before_my_account()
{
	echo '<p>';
	echo do_shortcode( '[minti_button link="http://maj.assomption-lubeck.com/boutique" size="medium" target="_self" lightbox="false" color="color-1" icon=""]ALLER À LA BOUTIQUE[/minti_button]' );
	echo '</p>';
}

/*
 * PASSWORD STRENGTH
 */
 
add_action( 'wp_print_scripts', 'remove_wc_password_meter', 100 );

function remove_wc_password_meter()
{
	wp_dequeue_script( 'wc-password-strength-meter' );
}

/*
 * STOCK AVAILABILITY
 */

add_filter('woocommerce_stock_html', 'STDI_stock_html', 20, 3);

function STDI_stock_html( $availability_html, $availability_text, $product )
{
	if ( $availability_text == 'Disponible sur commande' )
	{
		$availability_text = "Attention, plus de place, inscription sur liste d'attente";
		$availability_html = '<p class="stock available-on-backorder">' . esc_html( $availability_text ) . '</p>';
	}
	return 	$availability_html;
}

/*
 * BACKORDERED ITEM META NAME
 */

add_filter('woocommerce_backordered_item_meta_name', 'STDI_backordered_item_meta_name', 10, 0);

function STDI_backordered_item_meta_name()
{
  return __("Inscription sur liste d'attente", 'woocommerce');
}

/* ------------------------------------------------------------------------ */
/* EOF
/* ------------------------------------------------------------------------ */
?>