<?php
/**
 * Checkout billing information form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-billing.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.1.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/** @global WC_Checkout $checkout */

?>
<div class="woocommerce-billing-fields checkout">

	<?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>

	<div class="form-row">
		<h3><?php _e( 'DÉTAILS DE FACTURATION', 'woocommerce' ); ?></h3>
		
		<div class="form-row-first">
			<h3><?php _e("L’élève", 'woocommerce' ); ?></h3>

			<?php woocommerce_form_field( 'billing_student_first_name', $checkout->checkout_fields['billing']['billing_student_first_name'], $checkout->get_value( "Prénom de l'élève" ) ); ?>
			<?php woocommerce_form_field( 'billing_student_last_name', $checkout->checkout_fields['billing']['billing_student_last_name'], $checkout->get_value( "Nom de l'élève" ) ); ?>
			<?php woocommerce_form_field( 'billing_student_grade', $checkout->checkout_fields['billing']['billing_student_grade'], $checkout->get_value( 'Classe' ) ); ?>
		</div>

		<div class="form-row-first">
			<h3><?php _e('Les parents', 'woocommerce' ); ?></h3>
			
			<?php woocommerce_form_field( 'billing_first_name', $checkout->checkout_fields['billing']['billing_first_name'], $checkout->get_value( 'billing_first_name' ) ); ?>
			<?php woocommerce_form_field( 'billing_last_name', $checkout->checkout_fields['billing']['billing_last_name'], $checkout->get_value( 'billing_last_name' ) ); ?>
			<?php woocommerce_form_field( 'billing_address_1', $checkout->checkout_fields['billing']['billing_address_1'], $checkout->get_value( 'billing_address_1' ) ); ?>
			<?php woocommerce_form_field( 'billing_address_2', $checkout->checkout_fields['billing']['billing_address_2'], $checkout->get_value( 'billing_address_2' ) ); ?>
			<?php woocommerce_form_field( 'billing_postcode', $checkout->checkout_fields['billing']['billing_postcode'], $checkout->get_value( 'billing_postcode' ) ); ?>
			<?php woocommerce_form_field( 'billing_city', $checkout->checkout_fields['billing']['billing_city'], $checkout->get_value( 'billing_city' ) ); ?>
			<?php woocommerce_form_field( 'billing_phone', $checkout->checkout_fields['billing']['billing_phone'], $checkout->get_value( 'billing_phone' ) ); ?>
		</div>
	</div>
	
	<div class="clear" />
	
	<?php do_action('woocommerce_after_checkout_billing_form', $checkout ); ?>

</div>
